/**********************************************************

ADOBE SYSTEMS INCORPORATED 
Copyright 2005-2006 Adobe Systems Incorporated 
All Rights Reserved 

NOTICE:  Adobe permits you to use, modify, and 
distribute this file in accordance with the terms
of the Adobe license agreement accompanying it.  
If you have received this file from a source 
other than Adobe, then your use, modification,
or distribution of it requires the prior 
written permission of Adobe. 

*********************************************************/

/**********************************************************
 
Gradients.jsx

DESCRIPTION

This Sample creates a gradient and adds it to the Swatches 
palette and applies it to all pathItem objects in the document.
It shows the use of pathItems collection, RGBColor, Gradient 
and GradientColor objects.

**********************************************************/

// Main Code [Execution of script begins here]

//$.level = 1;
//debugger;
//
// If a document is open
if ( app.documents.length > 0 )
{
	var docPathItems = app.activeDocument.pathItems;

	if ( docPathItems.length > 0 )

	{
		// if the gradient already exists, display alert
                var gradientExists = false;
		var myGradients = app.activeDocument.gradients;
		var numberOfGradients = myGradients.length;
		var i;
		if (numberOfGradients > 0)
		{
		    for (i = 0; i < numberOfGradients; i++)
		    {
		        if (myGradients[i].name == "myGradient")
		        {
		            gradientExists = true;
		        }
		    }
		}   
		
		if (gradientExists == false)
		{
		    // Call createGradient function to create gradient myGradient
		    var myGradient = createGradient();
		    //debugger
		    // Apply gradient myGradient to all objects selected 
		    // in the document
		    for ( var i=0; i < docPathItems.length ; i++ )
		    {
		    	docPathItems[i].filled = true;
		    	docPathItems[i].fillColor = myGradient;
		    }
		    redraw();
		    alert( "Note that myGradient got created in the Swatches Palette." );
		}
		else
		{
		    alert("Gradient already exists, start script from a new document.");
		}
	}
	else
	{
		alert( "No Path Iems in the document." );
	}
}
else
{
	alert( "Please open any document with pathItems." );
}





/**********************************************************

Functions used by this script

**********************************************************/


/*********************************************************
 
createGradient: Function to create a new gradient with 2 
GradientStops

**********************************************************/

function createGradient()
{

	// Create color objects for both ends of the gradient
	var startColor = new RGBColor();
	var endColor = new RGBColor();
	startColor.red = 0;
	startColor.green = 100;
	startColor.blue = 255;
	endColor.red = 220;
	endColor.green = 0;
	endColor.blue = 100;
	

	// Create a new gradient
	// A new gradient always has 2 stops
	var theGradient = app.activeDocument.gradients.add();
	theGradient.name = "myGradient";
	theGradient.type = GradientType.LINEAR;
	

	// Modify the first gradient stop
	theGradient.gradientStops[0].rampPoint = 30;
	theGradient.gradientStops[0].midPoint = 60;
	theGradient.gradientStops[0].color = startColor;
	

	// Modify the last gradient stop
	theGradient.gradientStops[1].rampPoint = 80;
	theGradient.gradientStops[1].color = endColor;
	

	// Construct an Illustrator.GradientColor object referring to the
	// newly created gradient
	var myGradientColor = new GradientColor();
	myGradientColor.gradient = theGradient;
	return myGradientColor;
}



